package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Generic parser used to generate percentage rate for indicators that calculates only one rate (04, 05, 10)
 */
public class PercentageIndicatorParser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public PercentageIndicatorParser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        Object[] o = result.get(0);

        Float rate = (Float) o[3];

        return new SummaryIndicatorData(locationDesc,
                "dashboard.last12months",
                indicatorCode,
                rate,
                "%");
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        data.getIndicatorRates().get(0).setNationalRate(nationalResult.getIndicatorRates().get(0).getRate());

        return data;
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLast12MonthsPeriod();
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
